#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-

from binary2_5 import PDA, Fronta, MinHalda, MaxHalda, Mapa, udelej_obraz

# K dispozici dostavate tyto datove struktury:
# PDA - zasobnik s destruktivnim ctenim
#   push(prvek) - vlozi libovolny prvek na zasobnik
#   pop()       - odebere a vrati vrchol zasobniku
#
# Fronta
#   enqueue(prvek) - vlozi libovolny prvek na konec fronty
#   dequeue()      - odebere a vrati prvni prvek fronty
#
# MinHalda a MaxHalda - minimova a maximova halda
#   vloz(prvek)     - vlozi na haldu cele cislo
#   odeber_vrchol   - vrati a odstrani vrcholovy prvek haldy
#
# Mapa
#   vloz(klic, prvek) - pod dany klic vlozi prvek
#   najdi(klic)       - podle klice vlozi prvek
#
# Kazda ze struktur se inicializuje ve formatu
#   s = Struktura() -- kde Struktura je {PDA, Fronta, MinHalda, MaxHalda, Mapa}
# a prikazem
#   print s
# lze v peknem formatu vypsat obsah takove struktury
#
# Dale mate k dispozici velmi dulezitou funkci udelej_obraz(struktura), ktera
# vraci soucasny stav struktury jako novy objekt (jinymi slovy, vznikne
# struktura nezavisla na prvni strukture - zmeny prvni struktury ji uz
# neovlivnuji)


class KsantuvStajovyZaznamenavac(object):

    def __init__(self):
        self.heap = MinHalda()
        self.hist = []

    def proved(self, prikaz):
        '''
        Funkce pro provedeni prikazu ze staje.
        prikaz: {'akce': akce, 'data': data}
        kde akce a data ziskavaji tyto hodnoty:
            akce            data             vyznam
            ---------------------------------------
            pridej          seznam priorit   tedy napr. pole [0, 5, 9, 1]

            odeber          n                1 <= n <= soucasny pocet sobu

            vypis_epochu    n                0 < n <= pocet doposud vykonanych
                                             akci pridej a odeber

            spi             <neexistuje>     (tuto akci muzete ignorovat,
                                             ovsem musi dojit k zavolani return
        '''

        if prikaz['akce'] == 'pridej':
          for num in prikaz['data']:
            self.heap.vloz(num)
          self.hist.append(udelej_obraz(self.heap))
        elif prikaz['akce'] == 'odeber':
          for i in range(prikaz['data']):
            self.heap.odeber_vrchol()
          self.hist.append(udelej_obraz(self.heap))
        elif prikaz['akce'] == 'vypis_epochu':
          print self.hist[prikaz['data']-1]

